<!--
SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
SPDX-License-Identifier: BSD-2-Clause
-->

# Changelog

All notable changes to the check-build project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.1.1] - 2025-12-20

### Semi-incompatible changes

- Python implementation:
    - drop support for Python 3.10
    - switch from `format.version` to `mediaType` for the program
      definition file

### Fixes

- Python implementation:
    - test suite:
        - fix the prototype of a unit test

### Additions

- Add a Rust implementation
- Add a little bit of MkDocs-based documentation
- Python implementation:
    - build infrastructure:
        - declare Python 3.13 as a supported version

### Other changes

- Python implementation:
    - push everything down into `python/`
    - build infrastructure:
        - fold the runtime dependencies into `pyproject.toml`
        - switch to PEP 735 dependency groups
    - library:
        - minor improvements suggested by `ruff`
        - reformat the source code using `ruff`
        - push the source down into `src/`
        - push the unit tests down into `tests/unit/`
        - drop the long obsolete `MANIFEST.in` file
    - test suite:
        - use `reuse` 6.x with no changes
        - shuffle the `ruff` config files around a bit
        - use `ruff` 0.9.14
        - rewrite the functional test in Python and break it out into
          a test tool that may also be invoked separately e.g. to test
          the Rust implementation
        - use `uvoxen` to generate and run the tests
        - also run `ty` for type checking
        - use `pytest` 9.x and run it with the `--strict` option
- Drop the Nix testing environment, we use `uvoxen` to test with different
  Python versions now

## [0.1.0] - 2023-09-17

### Started

- First public release.

[Unreleased]: https://gitlab.com/ppentchev/check-build/-/compare/release%2F0.1.1...main
[0.1.1]: https://gitlab.com/ppentchev/check-build/-/compare/release%2F0.1.0...release/0.1.1
[0.1.0]: https://gitlab.com/ppentchev/check-build/-/tags/release%2F0.1.0
